package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.dna.ItemData;

import java.util.Random;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class TileEntityDNASequencer extends TileEntity implements IInventory{

	public int sequenceTime;

	private ItemStack[] items = new ItemStack[3];

	public int burnTime;

	public int currentItemBurnTime;


	public int getSizeInventory()
	{
		return this.items.length;
	}

	public ItemStack getStackInSlot(int par1)
	{
		return this.items[par1];
	}

	/**
	 * Removes from an inventory slot (first arg) up to a specified number (second arg) of items and returns them in a
	 * new stack.
	 */
	public ItemStack decrStackSize(int par1, int par2)
	{
		if (this.items[par1] != null)
		{
			ItemStack itemstack;

			if (this.items[par1].stackSize <= par2)
			{
				itemstack = this.items[par1];
				this.items[par1] = null;
				return itemstack;
			}
			else
			{
				itemstack = this.items[par1].splitStack(par2);

				if (this.items[par1].stackSize == 0)
				{
					this.items[par1] = null;
				}

				return itemstack;
			}
		}
		else
		{
			return null;
		}
	}

	public ItemStack getStackInSlotOnClosing(int par1)
	{
		if (this.items[par1] != null)
		{
			ItemStack itemstack = this.items[par1];
			this.items[par1] = null;
			return itemstack;
		}
		else
		{
			return null;
		}
	}

	/**
	 * Sets the given item stack to the specified slot in the inventory (can be crafting or armor sections).
	 */
	public void setInventorySlotContents(int par1, ItemStack par2ItemStack)
	{
		this.items[par1] = par2ItemStack;

		if (par2ItemStack != null && par2ItemStack.stackSize > this.getInventoryStackLimit())
		{
			par2ItemStack.stackSize = this.getInventoryStackLimit();
		}
	}

	/**
	 * Reads a tile entity from NBT.
	 */
	public void readFromNBT(NBTTagCompound nbt)
	{
		super.readFromNBT(nbt);
		NBTTagList nbttaglist = nbt.getTagList("Items");
		this.items = new ItemStack[this.getSizeInventory()];

		for (int i = 0; i < nbttaglist.tagCount(); ++i)
		{
			NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i);
			byte b0 = nbttagcompound1.getByte("Slot");

			if (b0 >= 0 && b0 < this.items.length)
			{
				this.items[b0] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
			}
		}
		sequenceTime =  nbt.getInteger("sequenceTime");
		burnTime = nbt.getInteger("burnTime");
		currentItemBurnTime = nbt.getInteger("currentItemBurnTime");
	}

	/**
	 * Writes a tile entity to NBT.
	 */
	public void writeToNBT(NBTTagCompound nbt)
	{
		super.writeToNBT(nbt);
		NBTTagList nbttaglist = new NBTTagList();

		for (int i = 0; i < this.items.length; ++i)
		{
			if (this.items[i] != null)
			{
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.setByte("Slot", (byte)i);
				this.items[i].writeToNBT(nbttagcompound1);
				nbttaglist.appendTag(nbttagcompound1);
			}
		}

		nbt.setTag("Items", nbttaglist);

		nbt.setInteger("sequenceTime", sequenceTime);
		nbt.setInteger("burnTime", burnTime);
		nbt.setInteger("currentItemBurnTime", currentItemBurnTime);
	}


	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		return false;
	}

	/**
	 * Returns the maximum stack size for a inventory slot. Seems to always be 64, possibly will be extended. *Isn't
	 * this more of a set than a get?*
	 */
	public int getInventoryStackLimit()
	{
		return 64;
	}


	@Override
	public void openChest() {
	}

	@Override
	public void closeChest() {
	}
	@Override
	public String getInvName() {
		return "DNA Sequencer";
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}

	@Override
	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		return true;
	}








	int currentIndex = 0;

	short[] randomProteins = new short[15];

	public short[] re_arranged = new short[15];

	Random rand = new Random();

	//Time to take = 4 minutes. 4800 ticks

	int timeToSequence = CloneCraft.isDebugMode()?120:4800;

	/**
	 * Returns an integer between 0 and the passed value representing how close the current item is to being completely
	 * cooked
	 */
	public int getSequenceProgressScaled(int par1)
	{
		return this.sequenceTime * par1 / timeToSequence;
	}

	@SideOnly(Side.CLIENT)

	/**
	 * Returns an integer between 0 and the passed value representing how much burn time is left on the current fuel
	 * item, where 0 means that the item is exhausted and the passed value means that the item is fresh
	 */
	public int getBurnTimeRemainingScaled(int par1)
	{
		if (this.currentItemBurnTime == 0)
		{
			this.currentItemBurnTime = 200;
		}

		return this.burnTime * par1 / this.currentItemBurnTime;
	}

	/**
	 * Returns true if the furnace is currently burning
	 */
	public boolean isBurning()
	{
		return this.burnTime > 0;
	}



	/**
	 * Allows the entity to update its state. Overridden in most subclasses, e.g. the mob spawner uses this to count
	 * ticks and creates a new spawn inside its implementation.
	 */
	public void updateEntity()
	{
		boolean flag = this.burnTime > 0;
		boolean flag1 = false;

		if (this.burnTime > 0)
		{
			--this.burnTime;
		}

		if (!this.worldObj.isRemote)
		{
			if (this.burnTime == 0 && this.canSequence())
			{
				this.currentItemBurnTime = this.burnTime = TileEntityFurnace.getItemBurnTime(this.items[0]);

				if (this.burnTime > 0)
				{
					flag1 = true;

					if (this.items[0] != null)
					{
						--this.items[0].stackSize;

						if (this.items[0].stackSize == 0)
						{
							this.items[0] = this.items[0].getItem().getContainerItemStack(items[0]);
						}
					}
				}
			}

			if (this.isBurning() && this.canSequence())
			{
				++this.sequenceTime;

				if (this.sequenceTime >= timeToSequence)
				{
					this.sequenceTime = 0;
					this.onSequenced();
					flag1 = true;
				}else{
					if(this.sequenceTime % 32 == 0){
						worldObj.playSoundEffect(xCoord, yCoord, zCoord, "clonecraft.humfade", 1.0f, 1.0f);
						//                 		System.out.println("Play");
					}
				}
			}
			else
			{
				this.sequenceTime = 0;
			}

			if (flag != this.burnTime > 0)
			{
				flag1 = true;
			}
		}
		if(worldObj.isRemote){
			if (this.isBurning() && this.canSequence()){
				randomProteins[currentIndex] = (short)(rand.nextInt(4)+1);

				for(int a = 0; a < randomProteins.length; a++){
					int index = currentIndex - a;
					if(index < 0){
						index += randomProteins.length;
					}
					short type = randomProteins[index];
					re_arranged[a] = type;
				}
				currentIndex++;
				if(currentIndex >= randomProteins.length){
					currentIndex = 0;
				}
			}else{
				for(int a = 0; a < randomProteins.length; a++){
					randomProteins[a] = 0;
				}
				for(int a = 0; a < randomProteins.length; a++){
					re_arranged[a] = 0;
				}
				currentIndex = 0;
			}
		}

		if (flag1)
		{
			this.onInventoryChanged();
		}

	}

	public void onSequenced(){
		ItemStack paper = items[1];
		if(paper != null){
			paper.itemID = CloneCraft.dnaData.itemID;
			ItemData data = null;
			paper.setItemDamage((data = new ItemData(items[2])).currentEntity);
			data.drain();
			data.save();
			items[2].setItemDamage(0);
		}
	}

	/**
	 * Returns true if the furnace can smelt an item, i.e. has a source item, destination stack isn't full, etc.
	 */
	private boolean canSequence(){
		if(items[1] != null && items[1].itemID == Item.paper.itemID){
			if(items[2] != null && items[2].itemID == CloneCraft.needle.itemID && items[2].getItemDamage() == 2){
				return true;
			}
		}
		return false;
	}
}
